#! /usr/bin/env python
#===================================
#  mergePDB.py
#
#   This short python script merges
# the specific coordinate info with
# the general protein info to re-
# assemble usable pdb files
#
# S.R. McAllister Mar 2006
#====================================
import sys
args= sys.argv

#If not enough args
if len(args)<=3:
    print("Please specify OutputFileName InputLabelName InputCoordName")
    print("(Only file prefixes, please.)")
else:
    #Read args
    fileName= sys.argv[1]
    labelName= sys.argv[2]
    coordName= sys.argv[3]

    #Create file names
    outpdbFileName=fileName+".pdb"
    inpdbllabelFileName=labelName+".llabel.pdb"
    inpdbcoordFileName=coordName+".coord.pdb"
    inpdbrlabelFileName=labelName+".rlabel.pdb"

    #Open file handles
    outpdbFile=open(outpdbFileName,'w')
    fhllabel= open(inpdbllabelFileName)
    fhcoord= open(inpdbcoordFileName)
    fhrlabel= open(inpdbrlabelFileName)

    #Read initial line
    llabelline= fhllabel.readline()
    coordline= fhcoord.readline()
    rlabelline= fhrlabel.readline()

    #Initialize counters/variables
    while llabelline:
        #If coordinate file has a header line, write it
        if coordline[0:6]=="HEADER":
            outpdbFile.write(coordline[0:-1]+'\n')
            coordline= fhcoord.readline()
        #If left label file is an atom line, paste info from all 3 files
        elif llabelline[0:4]=="ATOM":
            outpdbFile.write(llabelline[0:-1]+coordline[0:-1]+rlabelline[0:-1]+'\n')
            llabelline= fhllabel.readline()
            coordline= fhcoord.readline()
            rlabelline= fhrlabel.readline()
        #Else it is just another label, write it
        else:
            outpdbFile.write(llabelline[0:-1]+'\n')
            llabelline= fhllabel.readline()
     
sys.exit(0)
