#include <stdio.h>
#include <math.h>
#include <sys/time.h>

#define NBIN 8 
double begbin[NBIN]={3.0,4.0,5.0,5.5,6.0,6.5,7.0,8.0};
double endbin[NBIN]={4.0,5.0,5.5,6.0,6.5,7.0,8.0,9.0};

/*
#define NBIN 8 
double begbin[NBIN]={4.0,5.0,5.5,6.0,6.5,7.0,8.0,9.0};
double endbin[NBIN]={5.0,5.5,6.0,6.5,7.0,8.0,9.0,10.0};
*/
/*
#define NBIN 10
double begbin[NBIN]={3.5,4.5,5.0,5.5,6.0,6.5,7.0,8.0,9.0,10.0}; 
double endbin[NBIN]={4.5,5.0,5.5,6.0,6.5,7.0,8.0,9.0,10.0,11.0};
*/
/*
double begbin[NBIN]={2.0,3.0,4.0,4.5,5.0,5.5,6.0,6.5,7.0,8.0};
double endbin[NBIN]={3.0,4.0,4.5,5.0,5.5,6.0,6.5,7.0,8.0,9.0};
*/
#ifdef __LINUX__
#define dsyev dsyev_
#endif

extern void dsyev(char *jobz, char *uplo, int *n, double *a, int *lda,
             double *w, double *work, int *lwork, int *info);


main(argc, argv)
int     argc;
char    **argv;
{
  int  i, j, k,l, count;
  int  n, lwork, info;
  int  natom, *cbid;
  double sum1[3], sum2[3], r[9], s[9], v[3][3], c[3];
  double rn[9], sn[9], rtrn[9], rnt[9];
  double rtr[9], eigvec[9], eigval[3], work[37];
  double B[9], U[9];
  double det, sign, norm, dx, dot,rms;
  double eo, adj, rms2, dis, disbb;
  double **x1, **x2, **x1c, **x1n, **x2n;
  char  cjunk, name1[255], name2[255], name3[255], ext[255];
  char junk0[255], junk1[255], junk2[255], junk3[255], junk4[255], junk5[255], junk6[255];
  char **res, fname[255];
  int atomnum, aminonum;
  int ***freq, ***freqb, id, id1, id2, resid();
  FILE	*fopen(), *fx1, *fx2, *fout;
  

  if(argc == 1) {
    fprintf(stderr, "You should give the arguments as \n");
    fprintf(stderr, "file_1 file_2 file_out natom\n");
    exit(0);
  }
  
  id = atoi(argv[argc-1]);
  sprintf(ext, "%s", argv[argc-2]);
  natom   = atoi(argv[argc-3]);
  sprintf(name1, "%s", argv[argc-4]);
  sprintf(name2, "%s", argv[argc-5]);
  sprintf(name3, "%s", argv[argc-6]);
  
  fprintf(stderr, "%s %s %s\n", name3, name2, name1);
  fprintf(stderr, "%d\n", natom);
  
  x1 = (double **) malloc(natom * sizeof(double *));
  x2 = (double **) malloc(natom * sizeof(double *));
  x1c = (double **) malloc (natom * sizeof(double *));
  x1n = (double **) malloc (natom * sizeof(double *));
  x2n = (double **) malloc (natom * sizeof(double *));
  cbid = (int *) malloc (natom * sizeof(int));

  for (i=0 ; i<natom; i++){
    x1[i] = (double * ) malloc (3 * sizeof (double));
    x2[i] = (double * ) malloc (3 * sizeof (double));
    x1c[i] = (double * ) malloc (3 * sizeof (double));
    x1n[i] = (double * ) malloc (3 * sizeof (double));
    x2n[i] = (double * ) malloc (3 * sizeof (double));
    cbid[i] = 0;
  }

  res = (char **) malloc ( natom * sizeof(char *));

  if ( (fx1 = fopen(name3, "r")) == NULL) exit();
  if ( (fx2 = fopen(name2, "r")) == NULL) exit();
  fout = fopen(name1, "w");

  for(i=0; i<natom; i++){	  
    res[i] = (char *) malloc (5 * sizeof(char));
    if ((fscanf(fx1, "%4s %d %3s %3s%c%c%d %lf %lf %lf", &junk1, &atomnum, &junk2, &junk3, &cjunk, &cjunk, &aminonum, &x1[i][0], &x1[i][1], &x1[i][2])) == EOF) exit();
    sprintf(res[i], junk3);
    while ((cjunk=getc(fx1)) != '\n');
    if ((fscanf(fx2, "%4s %d %3s %3s%c%c%d %lf %lf %lf", &junk4, &atomnum, &junk5, &junk6, &cjunk, &cjunk, &aminonum, &x2[i][0], &x2[i][1], &x2[i][2])) == EOF) exit();
    while ((cjunk=getc(fx2)) != '\n');

    if (strcmp(junk2,"CB")==0) cbid[i] = 1;

    for (j=0; j<3; j++){
      sum1[j] = sum1[j] + x1[i][j];
      sum2[j] = sum2[j] + x2[i][j];
    }
    
  }

  fclose(fx1);
  fclose(fx2);

  for (j=0; j<3; j++){
    sum1[j] = sum1[j] /(1.0*natom);
    sum2[j] = sum2[j] /(1.0*natom);
  }
  
  for (i=0; i<natom; i++){
    for (j=0; j<3; j++){
      x1[i][j] = x1[i][j] - sum1[j];
      x2[i][j] = x2[i][j] - sum2[j];
    }
  }


  for (i=0; i<9; i++) r[i] = 0.0;
  
  for (i=0; i<natom; i++){
    for(j=0; j<3; j++){
      for(k=0; k<3; k++){
	s[j*3+k] = x2[i][j]*x1[i][k];
      }
    }
    for (j=0; j<9; j++){
      r[j] = r[j] + s[j];
    }
  }

  for (i=0; i<3; i++){
    for (j=0; j<3; j++){
      v[i][j] = r[i*3+j];
    }
  }

  c[0] = v[0][1]*v[1][2] - v[0][2]*v[1][1];
  c[1] = v[0][2]*v[1][0] - v[0][0]*v[1][2];
  c[2] = v[0][0]*v[1][1] - v[0][1]*v[1][0];

  det = 0.0;

  for (i=0; i<3; i++){
    det = det + c[i]*v[2][i];
  }

  sign = 1.0;
  if (det < 0.0 ) sign = -1.0;


  for (i=0; i<3; i++){
    for (j=0; j<3; j++){
      rtr[i*3+j] = 0.0;
      for (k=0; k<3; k++){
	rtr[i*3+j] = rtr[i*3+j] + r[k*3+i]*r[k*3+j];
      }
    }
  }

  n = 3;
  lwork = 12*3 + 1;
  
  for (i=0; i<9; i++) eigvec[i] = rtr[i];
  
  dsyev("V", "L", &n, eigvec, &n, eigval, work, &lwork, &info);

  for(i=0; i<3; ++i) {
    if(eigval[i] < 0.0) {
      eigval[i] = 0.0;
    } 
    else {
      eigval[i] = sqrt(eigval[i]);
    }
  }

  eigvec[0] = eigvec[4]*eigvec[8] - eigvec[5]*eigvec[7];
  eigvec[1] = eigvec[5]*eigvec[6] - eigvec[3]*eigvec[8];
  eigvec[2] = eigvec[3]*eigvec[7] - eigvec[4]*eigvec[6];

    
  for(l=2; l >= 0; l--) {

    for (i=0; i<3; i++){
      for (j=0; j<1; j++){
	B[3*l+i*1+j] = 0.0;
	for (k=0; k<3; k++){
	  B[3*l+i*1+j] = B[3*l+i*1+j] + r[i*3+k]*eigvec[3*l+k*1+j];
	}
      }
    }
    
    norm = 0.0;
    for (i=0; i<3; i++){
      norm = norm + B[3*l+i]*B[3*l+i];
    }
    norm = sqrt(norm);
    if (norm < 1.0e-6){
      /* */
    }
    else {
      for (i=0; i<3; i++){
	B[3*l+i] = B[3*l+i] * 1.0/norm;
      }
    }

    if (l==0){
      for (i=0; i<3; i++){
	B[3*l+i] = B[3*l+i] * 1.0;
	/*	B[3*l+i] = B[3*l+i] * sign; */
      }
      
    }

  }
  

  for (i=0; i<3; i++){
    for (j=0; j<3; j++){
      U[i*3+j] = 0.0;
      for (k=0; k<3; k++){
	U[i*3+j] = U[i*3+j] + B[k*3+i]*eigvec[k*3+j];
      }
    }
  }
  
  for (i=0; i<3; i++){
    for (j=0; j<3; j++){
      v[i][j] = U[i*3+j];
    }
  }

  c[0] = v[0][1]*v[1][2] - v[0][2]*v[1][1];
  c[1] = v[0][2]*v[1][0] - v[0][0]*v[1][2];
  c[2] = v[0][0]*v[1][1] - v[0][1]*v[1][0];

  det = 0.0;

  for (i=0; i<3; i++){
    det = det + c[i]*v[2][i];
  }

  rms = 0.0;

  eo = 0.0;
  for (l=0; l<natom; l++){
    for (j=0; j<3; j++){
      x1c[l][j] = x1[l][j];
    }
    
    for (i=0; i<3; i++){
      for (j=0; j<1; j++){
	x1n[l][i*1+j] = 0.0;
	for (k=0; k<3; k++){
	  x1n[l][i*1+j] = x1n[l][i*1+j] + U[i*3+k]*x1c[l][k*1+j];
	}
      }
      x2n[l][i] = x2[l][i];
    }


    dot = 0.0;
    for (i=0; i<3; i++){
      dx = x1n[l][i] - x2n[l][i];
      dot =  dot + dx*dx;
    }

    rms = rms + dot;

    eo = eo 
      + x1[l][0]*x1[l][0] + x1[l][1]*x1[l][1] + x1[l][2]*x1[l][2] 
      + x2[l][0]*x2[l][0] + x2[l][1]*x2[l][1] + x2[l][2]*x2[l][2];    
  }

  for (i=0; i<9; i++) rn[i] = 0.0;
  
  for (i=0; i<natom; i++){
    for(j=0; j<3; j++){
      for(k=0; k<3; k++){
	sn[j*3+k] = x2n[i][j]*x1n[i][k];
      }
    }
    for (j=0; j<9; j++){
      rn[j] = rn[j] + sn[j];
    }
  }

  for (i=0; i<3; i++){
    for (j=0; j<3; j++){
      rnt[i*3+j] = rn[j*3+i];
    }
  }

  for (i=0; i<3; i++){
    for (j=0; j<3; j++){
      rtrn[i*3+j] = 0.0;
      for (k=0; k<3; k++){
	rtrn[i*3+j] = rtrn[i*3+j] + rn[i*3+k]*rnt[k*3+j];
      }
    }
  }



  rms = sqrt(rms/(1.0*natom));

  if (sign < 0.0) adj = -1.0 * eigval[0];
  else adj = 1.0 * eigval[0];
  
  adj = adj + eigval[1] + eigval[2];
  
  rms2 = sqrt((eo - 2.0*adj)/(1.0*natom));
  

  fx2 = fopen(name2, "r");

  for (i=0; i<natom; i++){
    fscanf(fx2, "%4s %d %3s %3s%c%c%d %lf %lf %lf", &junk1, &atomnum, &junk2, &junk3, &cjunk, &cjunk, &aminonum, &x2[i][0], &x2[i][1], &x2[i][2]);
    while ((cjunk=getc(fx2)) != '\n');
    fprintf(fout, "%4s%7d%4s  %3s A%4d%12.3lf%8.3lf%8.3lf\n", junk1, atomnum, junk2, junk3, aminonum, x2n[i][0], x2n[i][1], x2n[i][2]);    
  }

  fclose(fx2);

  fx2 = fopen(name2, "r");

  for (i=0; i<natom; i++){
    fscanf(fx2, "%4s %d %3s %3s%c%c%d %lf %lf %lf", &junk1, &atomnum, &junk2, &junk3, &cjunk, &cjunk, &aminonum, &x2[i][0], &x2[i][1], &x2[i][2]);
    while ((cjunk=getc(fx2)) != '\n');
    fprintf(fout, "%4s%7d%4s  %3s B%4d%12.3lf%8.3lf%8.3lf\n", junk1, atomnum, junk2, junk3, aminonum, x1n[i][0], x1n[i][1], x1n[i][2]);    
  }

  fclose(fx2);

  fprintf(fout, "RMS %lf\n", rms, rms2);

  fclose(fout);

  freq = (int ***) malloc (natom * sizeof(int **));
  freqb = (int ***) malloc (natom * sizeof(int **));
  
  for (i=0; i<20; i++){
    freq[i] = (int **) malloc (natom * sizeof(int *));
    freqb[i] = (int **) malloc (natom * sizeof(int *));
    for (j=0; j<20; j++){
      freq[i][j] = (int *) malloc (NBIN * sizeof(int));
      freqb[i][j] = (int *) malloc (NBIN * sizeof(int));
      for (k=0; k<NBIN; k++) {
	freq[i][j][k] = 0;
	freqb[i][j][k] = 0;
      }
    }
  }
  
  for (i=0; i<natom; i++){
    id1 = resid(res[i]);
    for (j=i+1; j<natom; j++){
      id2 = resid(res[j]);
      dis = sqrt( pow(x1n[i][0]-x1n[j][0],2.0) + 
		  pow(x1n[i][1]-x1n[j][1],2.0) + 
		  pow(x1n[i][2]-x1n[j][2],2.0));
      if (cbid[i] == 0 && cbid[j] == 0){
	if (dis >= begbin[0] && dis < endbin[NBIN-1]){
	  for (k=0; k<NBIN; k++){
	    if (dis >= begbin[k] && dis < endbin[k]){
	      freq[id1][id2][k]++;
	    }
	  }
	}
      }
      else if (cbid[i] == 1 && cbid[j] == 1){
	dis = sqrt( pow(x1n[i-1][0]-x1n[j-1][0],2.0) + 
		    pow(x1n[i-1][1]-x1n[j-1][1],2.0) + 
		    pow(x1n[i-1][2]-x1n[j-1][2],2.0));
	disbb = sqrt( pow(x1n[i][0]-x1n[j][0],2.0) + 
		      pow(x1n[i][1]-x1n[j][1],2.0) + 
		      pow(x1n[i][2]-x1n[j][2],2.0));
	if (dis >= begbin[0] && dis < endbin[NBIN-1]){
	  for (k=0; k<NBIN; k++){
	    if (dis >= begbin[k] && dis < endbin[k]){
	      if (disbb < dis){
		freqb[id1][id2][k]++;
	      }
	    }
	  }	  
	}	
      }
    }
  }


  sprintf(fname, "%s.freq", name3);
  fout = fopen(fname, "w");

  count = 1;
  for (i=0; i<20; i++){
    for (j=i; j<20; j++){
      fprintf(fout, "%s.%d.%d\t", ext, 1, count++); 
      for (k=0; k<NBIN; k++){
	if (i!=j){
	  fprintf(fout, "%4d ", freq[i][j][k]+freq[j][i][k]);
	}
	else fprintf(fout, "%4d ", freq[i][j][k]);	
      }
      fprintf(fout, "\n");      
    }
  }
  fprintf(fout, "\n");
  fclose(fout);


  sprintf(fname, "%s.freqb", name3);
  fout = fopen(fname, "w");

  count = 1;
  for (i=0; i<20; i++){
    for (j=i; j<20; j++){
      fprintf(fout, "%s.%d.%d\t", ext, 1, count++); 
      for (k=0; k<NBIN-1; k++){
	if (i!=j){
	  fprintf(fout, "%4d ", freqb[i][j][k]+freqb[j][i][k]);
	}
	else fprintf(fout, "%4d ", freqb[i][j][k]);	
      }
      for (k=0; k<NBIN-1; k++){
	if (i!=j){
	  fprintf(fout, "%4d ", freq[i][j][k]+freq[j][i][k] - 
		  (freqb[i][j][k]+freqb[j][i][k]));
	}
	else fprintf(fout, "%4d ", freq[i][j][k]-freqb[i][j][k]);	
      }
      fprintf(fout, "\n");      
    }
  }
  fprintf(fout, "\n");
  fclose(fout);


  for (i=0; i<20; i++){
    for (j=0; j<20; j++){
      for (k=0; k<NBIN; k++){
	freq[i][j][k] = 0;
	freqb[i][j][k] = 0;
      }
    }
  }
  
  for (i=0; i<natom; i++){
    id1 = resid(res[i]);
    for (j=i+1; j<natom; j++){
      id2 = resid(res[j]);
      dis = sqrt( pow(x2n[i][0]-x2n[j][0],2.0) + 
		  pow(x2n[i][1]-x2n[j][1],2.0) + 
		  pow(x2n[i][2]-x2n[j][2],2.0));
      if (cbid[i] == 0 && cbid[j] == 0){
	if (dis >= begbin[0] && dis < endbin[NBIN-1]){
	  for (k=0; k<NBIN; k++){
	    if (dis >= begbin[k] && dis < endbin[k]){
	      freq[id1][id2][k]++;
	    }
	  }
	}
      }
      else if (cbid[i] == 1 && cbid[j] == 1){
	dis = sqrt( pow(x2n[i-1][0]-x2n[j-1][0],2.0) + 
		    pow(x2n[i-1][1]-x2n[j-1][1],2.0) + 
		    pow(x2n[i-1][2]-x2n[j-1][2],2.0));
	disbb = sqrt( pow(x2n[i][0]-x2n[j][0],2.0) + 
		      pow(x2n[i][1]-x2n[j][1],2.0) + 
		      pow(x2n[i][2]-x2n[j][2],2.0));
	if (dis >= begbin[0] && dis < endbin[NBIN-1]){
	  for (k=0; k<NBIN; k++){
	    if (dis >= begbin[k] && dis < endbin[k]){
	      if (disbb < dis){
		freqb[id1][id2][k]++;
	      }
	    }
	  }	  
	}	
      }
    }
  }
  
  sprintf(fname, "%s.freq", name2);
  fout = fopen(fname, "w");

  count = 1;
  for (i=0; i<20; i++){
    for (j=i; j<20; j++){
      fprintf(fout, "%s.%d.%d\t", ext, id+1, count++); 
      for (k=0; k<NBIN; k++){
	if (i!=j){
	  fprintf(fout, "%4d ", freq[i][j][k]+freq[j][i][k]);
	}
	else fprintf(fout, "%4d ", freq[i][j][k]);	
      }      
      fprintf(fout, "\n");
    }
  }
  fprintf(fout, "\n");
  fclose(fout);

  sprintf(fname, "%s.freqb", name2);
  fout = fopen(fname, "w");

  count = 1;
  for (i=0; i<20; i++){
    for (j=i; j<20; j++){
      fprintf(fout, "%s.%d.%d\t", ext, id+1, count++); 
      for (k=0; k<NBIN-1; k++){
	if (i!=j){
	  fprintf(fout, "%4d ", freqb[i][j][k]+freqb[j][i][k]);
	}
	else fprintf(fout, "%4d ", freqb[i][j][k]);	
      }      
      for (k=0; k<NBIN-1; k++){
	if (i!=j){
	  fprintf(fout, "%4d ", freq[i][j][k]+freq[j][i][k]-
		  (freqb[i][j][k]+freqb[j][i][k]));
	}
	else fprintf(fout, "%4d ", freq[i][j][k]-freqb[i][j][k]);	
      }      
      fprintf(fout, "\n");
    }
  }
  fprintf(fout, "\n");
  fclose(fout);
    
}


int resid(char *s)
{
  if (strcmp(s,"ALA")==0) return 0;
  else if (strcmp(s, "CYS")==0) return 1;
  else if (strcmp(s, "ASP")==0) return 2;
  else if (strcmp(s, "GLU")==0) return 3;
  else if (strcmp(s, "PHE")==0) return 4;
  else if (strcmp(s, "GLY")==0) return 5;
  else if (strcmp(s, "HIS")==0) return 6;
  else if (strcmp(s, "ILE")==0) return 7;
  else if (strcmp(s, "LYS")==0) return 8;
  else if (strcmp(s, "LEU")==0) return 9;
  else if (strcmp(s, "MET")==0) return 10;
  else if (strcmp(s, "ASN")==0) return 11;
  else if (strcmp(s, "PRO")==0) return 12;
  else if (strcmp(s, "GLN")==0) return 13;
  else if (strcmp(s, "ARG")==0) return 14;
  else if (strcmp(s, "SER")==0) return 15;
  else if (strcmp(s, "THR")==0) return 16;
  else if (strcmp(s, "VAL")==0) return 17;
  else if (strcmp(s, "TRP")==0) return 18;
  else if (strcmp(s, "TYR")==0) return 19;
}




/*
cc -Aa -O -o align_and_dis_beta align_and_dis_beta.c -L/opt/fortran90/lib/ -llapack -lblas -lm -lcl -lU77

 cc -D__LINUX__ -o align_and_dis_beta align_and_dis_beta.c -L/usr/local/pgi/linux86/lib/ -lblas -llapack -lblas -lm -lpgftnrtl -lC -lpgc

*/
